<?php
/**
 * German language pack for MyBB 1.8 (informal)
 * Deutsches Sprachpaket für MyBB 1.8 "informell" (Du)
 * (c) 2005-2014 MyBBoard.de
 * 
 * Author/Autor: http://www.mybboard.de/
 * License/Lizenz: GNU Lesser General Public License, Version 3
 */

$l['board_settings'] = "Foreneinstellungen";
$l['change_settings'] = "Einstellungen ändern";
$l['change_settings_desc'] = "Dieser Bereich erlaubt es dir, Einstellungen für dein Forum vorzunehmen. Bitte wähle eine der unten aufgeführten Gruppen, um zu den Einstellungen zu gelangen.";
$l['add_new_setting'] = "Neue Einstellung";
$l['add_new_setting_desc'] = "Hier kannst du eine neue Einstellung hinzufügen.";
$l['modify_existing_settings'] = "Existierende Einstellungen ändern";
$l['modify_existing_settings_desc'] = "In diesem Bereich kannst du bestehende Einstellungen bearbeiten.";
$l['add_new_setting_group'] = "Neue Einstellungsgruppe";
$l['add_new_setting_group_desc'] = "Hier kannst du eine Einstellungsgruppe erstellen, um Einstellungen kategorisieren zu können.";
$l['edit_setting_group'] = "Einstellungsgruppe bearbeiten";
$l['edit_setting_group_desc'] = "In diesem Bereich kannst du bestehende Einstellungsgruppen bearbeiten.";

$l['title'] = "Titel";
$l['description'] = "Beschreibung";
$l['group'] = "Gruppe";
$l['display_order'] = "Sortierung";
$l['name'] = "Kennung";
$l['name_desc'] = "Diese eindeutige Kennung wird im Einstellungsarray bereitgestellt, um auf diese Einstellung zu verweisen (in Skripten, Übersetzungen und Templates).";
$l['group_name_desc'] = "Diese eindeutige Kennung wird im Sprachsystem verwendet.";
$l['text'] = "Text";
$l['numeric_text'] = "Numerischer Text";
$l['textarea'] = "Textarea";
$l['yesno'] = "Ja/Nein-Wahl";
$l['onoff'] = "An/Aus-Wahl";
$l['select'] = "Auswahlbox";
$l['radio'] = "Radiobuttons";
$l['checkbox'] = "Checkboxen";
$l['language_selection_box'] = "Sprachauswahlbox";
$l['forum_selection_box'] = "Forenauswahlbox";
$l['forum_selection_single'] = "Forenauswahlbox";
$l['group_selection_box'] = "Gruppenauswahlbox";
$l['group_selection_single'] = "Gruppenauswahlbox";
$l['adminlanguage'] = "Administrations-Sprachauswahlbox";
$l['cpstyle'] = "Control Panel-Style Auswahlbox";
$l['prefix_selection_box'] = "Präfixauswahlbox";
$l['php'] = "Geprüfter PHP-Code";
$l['type'] = "Typ";
$l['extra'] = "Extra";
$l['extra_desc'] = "Wenn es sich um eine Auswahlbox, Checkboxen oder Radiobuttons handelt, gib hier paarweise Kennung und Beschreibung an (Schlüssel=Beschreibung). Verwende für jede Option eine neue Zeile. Wenn es sich um PHP-Code handelt, gib diesen bitte ein.";
$l['value'] = "Wert(e)";
$l['insert_new_setting'] = "Neue Einstellung speichern";
$l['edit_setting'] = "Einstellung bearbeiten";
$l['delete_setting'] = "Einstellung löschen";
$l['setting_configuration'] = "Einstellungs-Konfiguration";
$l['update_setting'] = "Einstellung aktualisieren";
$l['save_settings'] = "Einstellungen speichern";
$l['setting_groups'] = "Einstellungsgruppen";
$l['bbsettings'] = "Einstellungen";
$l['insert_new_setting_group'] = "Neue Einstellungsgruppe speichern";
$l['setting_group_setting'] = "Einstellungsgruppe / Einstellung";
$l['order'] = "Sortierung";
$l['delete_setting_group'] = "Einstellungsgruppe löschen";
$l['save_display_orders'] = "Sortierung speichern";
$l['update_setting_group'] = "Einstellungsgruppe aktualisieren";
$l['modify_setting'] = "Einstellung bearbeiten";
$l['search'] = "Suche";
$l['plugin_settings'] = "Plugin-Einstellungen";

$l['show_all_settings'] = "Zeige alle Einstellungen";
$l['settings_search'] = "Suche nach Einstellung(en)";

$l['confirm_setting_group_deletion'] = "Soll diese Einstellungsgruppe wirklich gelöscht werden?";
$l['confirm_setting_deletion'] = "Soll diese Einstellung wirklich gelöscht werden?";

$l['error_format_dimension'] = "Das Format von {1} ist ungültig.";
$l['error_field_minnamelength'] = "Die Mindestlänge darf nicht länger als die Maximallänge des Namens sein";
$l['error_field_minpasswordlength'] = "Die Mindestlänge darf nicht länger als die Maximallänge des Passworts sein";
$l['error_field_minpasswordlength_complex'] = "Die Mindestlänge eines komplexen Password kann nicht kürzer als 3 Zeichen sein";
$l['error_field_postmaxavatarsize'] = "Maximale Avatar-Größe";
$l['error_field_useravatardims'] = "Standard-Avatar-Größe";
$l['error_field_maxavatardims'] = "Maximale Avatar-Größe";
$l['error_field_memberlistmaxavatarsize'] = "Maximale Avatar-Größe";
$l['error_missing_title'] = "Du hast keinen Titel für diese Einstellung angegeben.";
$l['error_missing_group_title'] = "Du hast keinen Titel für diese Einstellungsgruppe angegeben.";
$l['error_invalid_gid'] = "Du hast keine gültige Gruppe für diese Einstellung ausgewählt.";
$l['error_invalid_gid2'] = "Du bist einem Link zu einer ungültigen Einstellungsgruppe gefolgt. Bitte stelle sicher, dass diese existiert.";
$l['error_missing_name'] = "Du hast keine Kennung für diese Einstellung angegeben.";
$l['error_missing_group_name'] = "Du hast keine Kennung für diese Einstellungsgruppe angegeben.";
$l['error_invalid_type'] = "Du hast keinen gültigen Typ für diese Einstellung gewählt.";
$l['error_invalid_sid'] = "Die angegebene Einstellung existiert nicht.";
$l['error_duplicate_name'] = "Die angegebene Kennung wird bereits für die Einstellung \"{1}\" verwendet. Die Kennung muss aber einzigartig sein.";
$l['error_duplicate_group_name'] = "Die angegebene Kennung wird bereits für die Einstellungsgruppe \"{1}\" verwendet. Die Kennung muss aber einzigartig sein.";
$l['error_no_settings_found'] = "Es wurden keine Einstellungen gefunden, die zu deiner Eingabe passen.";
$l['error_cannot_edit_default'] = "Standard-Einstellungen und -Einstellungsgruppen können nicht bearbeitet oder gelöscht werden.";
$l['error_cannot_edit_php'] = "Dieser spezielle Einstellungs-Typ kann nicht bearbeitet werden.";
$l['error_ajax_search'] = "Bei der Suche ist ein Fehler aufgetreten:";
$l['error_ajax_unknown'] = "Bei der Suche ist ein unbekannter Fehler aufgetreten.";
$l['error_chmod_settings_file'] = "Die Datei \"./inc/settings.php\" ist nicht beschreibbar. Bitte setze die CHMOD-Rechte auf 666.<br />Weitere Informationen findest du in der <a href=\"https://www.mybb.de/doku/installationaktualisierung/installation/\" target=\"_blank\" rel=\"noopener\">Doku</a>.";
$l['error_admin_email_settings_empty'] = '<div class="smalltext" style="font-weight: normal;">Bitte beachte, dass die Einstellung <strong>E-Mail-Adresse des Administrators</strong> nicht gespeichert wurde, da die Einstellung nicht leer sein darf und eine gültige E-Mail-Adresse sein muss.</div>';

$l['success_setting_added'] = "Die Einstellung wurde erfolgreich erstellt.";
$l['success_setting_updated'] = "Die Einstellung wurde erfolgreich aktualisiert.";
$l['success_setting_deleted'] = "Die Einstellung wurde erfolgreich gelöscht.";
$l['success_settings_updated'] = "Die Einstellungen wurden erfolgreich aktualisiert.";
$l['success_settings_updated_hiddencaptchaimage'] = '<div class="smalltext" style="font-weight: normal;">Bitte beachte, dass die Einstellung <strong>Verstecktes Captcha-Feld</strong> auf {1} zurückgesetzt wurde, da es zu einem Konflikt mit dem Feld <strong>{2}</strong> des Registrierungs-Formulars kommt.</div>';
$l['success_settings_updated_username_method_conflict'] = '<div class="smalltext" style="font-weight: normal;">Bitte beachte, dass die Einstellung <b>Erlaubte Login-Methoden</b> nicht geändert werden konnte, da E-Mail-Adressen derzeit mehrfach genutzt werden dürfen.</div>';
$l['success_settings_updated_username_method'] = '<div class="smalltext" style="font-weight: normal;">Bitte beachte, dass die Einstellung <b>Erlaubte Login-Methoden</b> nicht geändert werden konnte, da aktuell mehrere Benutzer die selbe E-Mail-Adresse verwenden.</div>';
$l['success_settings_updated_allowmultipleemails'] = '<div class="smalltext" style="font-weight: normal;">Bitte beachte, dass die Einstellung <b>Erlaube mehrfache Registrierung mit der gleichen E-Mail-Adresse?</b> nicht geändert werden konnte, da die Option <b>Erlaubte Login-Methoden</b> eine Anmeldung mit der E-Mail-Adresse erlaubt.</div>';
$l['success_settings_updated_captchaimage'] = '<div class="smalltext" style="font-weight: normal;">Bitte beachte, dass die Einstellung <strong>
Bestätigungsgrafik (Captcha) bei Registrierung und Beitragserstellung</strong> auf <strong>MyBB Standard-Captcha</strong> zurückgesetzt wurde, da keine Private oder Public Keys hinterlegt wurden.</div>';
$l['success_settings_updated_minsearchword'] = '<div class="smalltext" style="font-weight: normal;">Bitte beachte, dass die Einstellung <strong>Minimale Suchbegriffslänge</strong> an die Konfiguration der Datenbank angepasst wurde.</div>';
$l['success_display_orders_updated'] = "Die Sortierung wurde erfolgreich aktualisiert.";
$l['success_setting_group_added'] = "Die Einstellungsgruppe wurde erfolgreich erstellt.";
$l['success_setting_group_updated'] = "Die Einstellungsgruppe wurde erfolgreich aktualisiert.";
$l['success_setting_group_deleted'] = "Die Einstellungsgruppe wurde erfolgreich gelöscht.";
$l['success_duplicate_settings_deleted'] = "Alle doppelten Einstellungen wurden erfolgreich gelöscht.";

$l['searching'] = 'Suchen&hellip;';
$l['search_error'] = 'Es ist zu einem Fehler beim Laden der Suchergebnisse gekommen:';
$l['search_done'] = 'Fertig!';

// Einstellungsgruppen
$l['setting_group_onlineoffline'] = "Forum online/offline";
$l['setting_group_onlineoffline_desc'] = "Hier kannst du dein Forum komplett ein- oder ausschalten und einen Grund für den Offline-Modus angeben. Administratoren können weiterhin das Forum betreten.";
$l['setting_group_details'] = "Seiten-Details";
$l['setting_group_details_desc'] = "Dieser Bereich enthält verschiedene Einstellungen, wie z. B. die URL deines Forums, genauso wie den Namen deiner Webseite und deren URL";
$l['setting_group_general'] = "Allgemeine Konfiguration";
$l['setting_group_general_desc'] = "In diesem Bereich finden sich allgemeine Einstellungen des Forums.";
$l['setting_group_server'] = "Server und Optimierung";
$l['setting_group_server_desc'] = "Diese Optionen helfen dir, die Last des Servers zu verringern und dein Forum zu beschleunigen.";
$l['setting_group_datetime'] = "Datums- und Zeitformat";
$l['setting_group_datetime_desc'] = "In diesem Bereich kannst du die Formate für Datum und Zeit anpassen.";
$l['setting_group_forumhome'] = "Startseite";
$l['setting_group_forumhome_desc'] = "In diesem Bereich kannst du Einstellungen für die Startseite (index.php) vornehmen und beispielsweise bestimmte Funktionen ein- oder ausschalten.";
$l['setting_group_forumdisplay'] = "Forenanzeige";
$l['setting_group_forumdisplay_desc'] = "In diesem Bereich kannst du Einstellungen für die Forenanzeige (forumdisplay.php) vornehmen und beispielsweise bestimmte Funktionen ein- oder ausschalten.";
$l['setting_group_showthread'] = "Themenanzeige";
$l['setting_group_showthread_desc'] = "Einstellungen der Anzeigeoptionen der Themenübersicht (showthread.php) im Forum, z. B. können hier verschiedene Features ein- oder ausgeschaltet werden.";
$l['setting_group_member'] = "Login und Registrierung";
$l['setting_group_member_desc'] = "In diesem Bereich sind verschiedene Einstellungen zur Registrierung und zum Login zu finden.";
$l['setting_group_profile'] = "Profil";
$l['setting_group_profile_desc'] = "Die Optionen hier steuern verschiedene Einstellungen bezüglich der Benutzerprofile.";
$l['setting_group_posting'] = "Beitragserstellung";
$l['setting_group_posting_desc'] = "Optionen zur Erstellung von Beiträgen im Forum.";
$l['setting_group_attachments'] = "Attachments";
$l['setting_group_attachments_desc'] = "Verschiedene Einstellungen zum Attachment-System können hier verwaltet und gesetzt werden.";
$l['setting_group_memberlist'] = "Mitgliederliste";
$l['setting_group_memberlist_desc'] = "In diesem Bereich lassen sich verschiedene Aspekte der Benutzerlistenanzeige einstellen (memberlist.php), wie z. B. die Anzahl der Benutzer pro Seite und welche Features ein- und welche ausgeschaltet werden sollen.";
$l['setting_group_reputation'] = "Bewertungssystem";
$l['setting_group_reputation_desc'] = "Das Bewertungssystem (reputation.php) erlaubt es den Benutzern, sich gegenseitig zu bewerten und Kommentare zu hinterlassen. Hier kannst du verschiedene Aspekte dieses Systems kontrollieren.";
$l['setting_group_warning'] = "Warnsystem";
$l['setting_group_warning_desc'] = "Das Warnsystem erlaubt es den Teammitgliedern, Benutzer bei Regelverstößen zu verwarnen. Hier kannst du dieses System (warnings.php) konfigurieren.";
$l['setting_group_privatemessaging'] = "Private Nachrichten";
$l['setting_group_privatemessaging_desc'] = "Verschiedene Einstellungen des Private Nachrichten-Systems (private.php) können hier vorgenommen werden.";
$l['setting_group_calendar'] = "Kalender";
$l['setting_group_calendar_desc'] = "Im Kalender werden öffentliche und private Ereignisse sowie Geburtstage angezeigt. Hier kannst du die Einstellungen anpassen (calendar.php).";
$l['setting_group_whosonline'] = "Wer ist online?";
$l['setting_group_whosonline_desc'] = "Verschiedene Einstellungen für die \"Wer ist online?\"-Funktion (online.php).";
$l['setting_group_userpruning'] = "Benutzer bereinigen";
$l['setting_group_userpruning_desc'] = "Benutzer können nach verschiedenen Kriterien automatisch entfernt werden. Hier können diese Kriterien angegeben werden.";
$l['setting_group_portal'] = "Portal";
$l['setting_group_portal_desc'] = "Auf der Portalseite (portal.php) werden verschiedene Informationen des Forums zusammengefasst dargestellt, darunter eine Statistik, Ankündigungen und die letzten Beiträge. In diesem Bereich kannst du das Portal konfigurieren.";
$l['setting_group_search'] = "Suchfunktion";
$l['setting_group_search_desc'] = "Die Einstellungen in diesem Bereich erlauben es dir, Änderungen an der Suchfunktion durchzuführen.";
$l['setting_group_clickablecode'] = "Smilies und BBCode";
$l['setting_group_clickablecode_desc'] = "In diesem Bereich kannst du das Aussehen der Smilie-Liste neben dem Editor bestimmen und den Standard-MyCode anpassen.";
$l['setting_group_cpprefs'] = "Admin Control Panel";
$l['setting_group_cpprefs_desc'] = "Hier kannst du allgemeine Einstellungen für das Admin-CP vornehmen.";
$l['setting_group_mailsettings'] = "E-Mail";
$l['setting_group_mailsettings_desc'] = "In diesem Bereich kannst du das Mailsystem des MyBB konfigurieren. Du kannst zum Beispiel wählen, ob E-Mails per PHP oder über einen SMTP-Server verschickt werden sollen";
$l['setting_group_contactsettings'] = "Kontakt-Formular";
$l['setting_group_contactsettings_desc'] = "Verschiedene Einstellungen zum Verhalten des Kontakt-Formulars (contact.php).";
$l['setting_group_purgespammer'] = "Spammer löschen";
$l['setting_group_purgespammer_desc'] = "Dieser Bereich erlaubt dir die Funktion um Spammer zu löschen anzupassen.";
$l['setting_group_stopforumspam'] = "Stop Forum Spam";
$l['setting_group_stopforumspam_desc'] = "In diesem Bereich kannst du die Einstellung zur Integration von StopForumSpam.com verändern.";
$l['setting_group_contactdetails'] = "Kontaktmöglichkeiten";
$l['setting_group_contactdetails_desc'] = "Dieser Bereich erlaubt dir die Felder mit Kontaktmöglichkeiten anzupassen.";
$l['setting_group_statspage'] = "Forenstatistik";
$l['setting_group_statspage_desc'] = "Dieser Bereich erlaubt dir die Forenstatistik zu konfigurieren.";
$l['setting_group_forumteam'] = "Foren-Team";
$l['setting_group_forumteam_desc'] = "Dieser Bereich erlaubt dir verschiedene Einstellung zur Anzeige des Forum-Teams (showteam.php) anzupassen.";

// Einstellungen
$l['setting_boardclosed'] = "Forum offline?";
$l['setting_boardclosed_desc'] = "Hier kann das komplette Forum offline bzw. online gestellt werden. Alle Besucher sehen dann nur die Nachricht, die du unten eingeben kannst.<br /><br /><b>Administratoren können das Forum weiterhin betreten.</b>";
$l['setting_boardclosed_reason'] = "Grund für den Offline-Modus";
$l['setting_boardclosed_reason_desc'] = "Wenn dein Forum offline ist, kannst du hier eine Nachricht eingeben, die den Besuchern angezeigt wird. Du kannst dieses Feld leer lassen um die Sprachdateien zu benutzen.";
$l['setting_bbname'] = "Name des Forums";
$l['setting_bbname_desc'] = "Der Name deines Forums. Es wird empfohlen, einen Namen zu wählen, der nicht länger als 75 Zeichen ist.";
$l['setting_bburl'] = "URL zum Forum";
$l['setting_bburl_desc'] = "Die Adresse des Forums (inklusive http://). Gib am Ende KEINEN Slash (/) an.";
$l['setting_homename'] = "Name der Homepage";
$l['setting_homename_desc'] = "Der Name deiner Homepage. Auf jeder Seite des Forums wird in der Fußzeile ein Link zu dieser Seite angezeigt.";
$l['setting_homeurl'] = "URL der Homepage";
$l['setting_homeurl_desc'] = "Die komplette Adresse deiner Homepage (inklusive http://).";
$l['setting_adminemail'] = "E-Mail-Adresse des Administrators";
$l['setting_adminemail_desc'] = "Die E-Mail-Adresse des Administrators. Diese wird als Absender für ausgehende E-Mails des Forums benutzt.";
$l['setting_returnemail'] = "Antwort E-Mail-Adresse";
$l['setting_returnemail_desc'] = "Gib die E-Mail-Adresse ein, an die Antworten auf versandte E-Mails geschickt werden sollen. Wenn leer, wird die E-Mail-Adresse des Administrators benutzt.";
$l['setting_contactemail'] = "Kontakt E-Mail-Adresse";
$l['setting_contactemail_desc'] = "Die E-Mail-Adresse, an die Nachrichten über das Kontaktformular (contact.php) gesendet werden. Wenn leer, wird die E-Mail-Adresse des Administrators benutzt.";
$l['setting_contactlink'] = "Kontakt-Link";
$l['setting_contactlink_desc'] = "Der Kontakt-Link wird auf jeder Seite in der Fußzeile angezeigt. Dafür kannst du eine E-Mail-Adresse (mailto:email@domain.tld) oder einen Hyperlink (http://www.domain.tld/kontakt.php) angeben.";
$l['setting_cookiedomain'] = "Cookie-Domain";
$l['setting_cookiedomain_desc'] = "Die Domain, zu der die Cookies gesetzt werden. Dieses Feld kann leer gelassen werden. Die Domain sollte mit einem . angegeben werden, so dass auch alle Subdomains mit eingeschlossen sind (Beispiel: .domain.tld).";
$l['setting_cookiepath'] = "Cookie-Pfad";
$l['setting_cookiepath_desc'] = "Der Pfad, zu dem die Cookies gesetzt werden. Wir empfehlen, die komplette Adresse zu deinem Forum anzugeben - inklusive Slash (/) am Ende (Beispiel: /forum/).";
$l['setting_cookieprefix'] = "Cookie-Präfix";
$l['setting_cookieprefix_desc'] = "Der Präfix wird dem Namen aller Cookies vorangestellt. Diese Option ist sinnvoll, wenn du mehrere Foren unter der gleichen Domain betreibst. Wenn das Feld leer ist, wird kein Präfix verwendet.";
$l['setting_cookiesamesiteflag'] = "SameSite Cookie Flag";
$l['setting_cookiesamesiteflag_desc'] = "Authentifizierungs-Cookies werden das SameSite-Flag erhalten um CSRF-Attacken zu verhindern. Deaktiviere diese Option, wenn du ursprungsübergreifende POST-Anfragen erwartest.";
$l['setting_cookiesecureflag'] = "Cookies nur über HTTPS";
$l['setting_cookiesecureflag_desc'] = "Diese Option verhindert, dass Cookies über unverschlüsselte Verbindungen übertragen werden. Du solltest diese Einstellung nur aktivieren, wenn dein Forum ausschließlich über HTTPS erreichbar ist.";
$l['setting_showvernum'] = "Zeige Versionsnummer";
$l['setting_showvernum_desc'] = "Erlaubt dir die Deaktivierung der Versionsanzeige des MyBB im Footer.";
$l['setting_mailingaddress'] = "COPPA Adresse";
$l['setting_mailingaddress_desc'] = "Gib die Anschrift ein, die auf dem COPPA-Formular angezeigt werden soll.";
$l['setting_faxno'] = "COPPA Faxnummer";
$l['setting_faxno_desc'] = "Gib die Faxnummer ein, die auf dem COPPA-Formular angezeigt werden soll.";
$l['setting_bblanguage'] = "Standard-Sprache";
$l['setting_bblanguage_desc'] = "Die Standard-Sprache deines Forums für Gäste und Benutzer, die keine Sprachauswahl in ihrem Benutzer-CP getroffen haben.";
$l['setting_captchaimage'] = "Bestätigungsgrafik (Captcha) bei Registrierung und Beitragserstellung";
$l['setting_captchaimage_desc'] = "Wenn ja, müssen Benutzer bei der Registrierung und Gäste bei der Beitragserstellung den Code aus einer Grafik eingeben (GD muss dazu auf deinem Server installiert sein). Dadurch werden automatisierte Vorgänge verhindert.";
$l['setting_captchaimage_0'] = "Kein Captcha";
$l['setting_captchaimage_1'] = "MyBB Standard-Captcha";
$l['setting_captchaimage_4'] = "NoCAPTCHA reCAPTCHA";
$l['setting_captchaimage_5'] = "Unsichtbares reCAPTCHA";
$l['setting_captchaimage_6'] = "hCaptcha";
$l['setting_captchaimage_7'] = "Unsichtbares hCaptcha";
$l['setting_captchaimage_8'] = "reCAPTCHA v3";
$l['setting_recaptchapublickey'] = "reCAPTCHA Public Key";
$l['setting_recaptchapublickey_desc'] = "Dein reCAPTCHA Public Key.";
$l['setting_recaptchaprivatekey'] = "reCAPTCHA Private Key";
$l['setting_recaptchaprivatekey_desc'] = "Dein reCAPTCHA Private Key.";
$l['setting_recaptchascore'] = "reCAPTCHA v3 Bewertung";
$l['setting_recaptchascore_desc'] = "Lege die Bewertung zur Benutzerabweisung für reCAPTCHA v3 fest. 1.0 ist sehr wahrscheinlich ein echter Benutzer, 0.0 ist sehr wahrscheinlich ein Bot";
$l['setting_hcaptchapublickey'] = "hCaptcha Public Key";
$l['setting_hcaptchapublickey_desc'] = "Dein hCaptcha Public Key";
$l['setting_hcaptchaprivatekey'] = "hCaptcha Private Key";
$l['setting_hcaptchaprivatekey_desc'] = "Dein hCaptcha Private Key";
$l['setting_hcaptchatheme'] = "hCaptcha Theme";
$l['setting_hcaptchatheme_desc'] = "Lege die Farbe des hCaptcha-Widgets fest.";
$l['setting_hcaptchatheme_light'] = "Hell";
$l['setting_hcaptchatheme_dark'] = "Dunkel";
$l['setting_hcaptchasize'] = "hCaptcha Größe";
$l['setting_hcaptchasize_desc'] = "Lege die Größe des hCaptcha-Widgets fest.";
$l['setting_hcaptchasize_normal'] = "Normal";
$l['setting_hcaptchasize_compact'] = "Kompakt";
$l['setting_reportmethod'] = "Benachrichtigung über Meldungen";
$l['setting_reportmethod_desc'] = "Bitte wähle aus der Liste, wie über Meldungen informiert werden soll. Hinweis: Moderatoren werden nur über Beiträge aus Foren, die sie moderieren, informiert; Super-Moderatoren über alle Meldungen.";
$l['setting_reportmethod_db'] = "Nur im Moderator-CP anzeigen";
$l['setting_reportmethod_pms'] = "Per PN informieren und im Moderator-CP anzeigen";
$l['setting_reportmethod_email'] = "Per E-Mail informieren und im Moderator-CP anzeigen";
$l['setting_statslimit'] = "Statistik-Limit";
$l['setting_statslimit_desc'] = "Die Anzahl der Themen mit den meisten Ansichten und den meisten Antworten, die in der Statistik erscheinen (0 = Keine Beschränkung).";
$l['setting_statstopreferrer'] = "Zeige Benutzer mit den meisten Empfehlungen auf der Statistik-Seite";
$l['setting_statstopreferrer_desc'] = "Soll der Benutzer mit den meisten Empfehlungen auf der Statistik-Seite (stats.php) angezeigt werden? Dies verursacht eine zusätzliche Datenbankabfrage.";
$l['setting_decpoint'] = "Dezimalzeichen";
$l['setting_decpoint_desc'] = "Das Dezimalzeichen, das in deiner Region verwendet wird (Empfohlene Einstellung für Deutschland: \",\").";
$l['setting_thousandssep'] = "Tausendertrennung";
$l['setting_thousandssep_desc'] = "Das Zeichen, das du verwenden möchtest (Beispiel: Die Einstellung \".\" zeigt die Zahl 1200 als 1.200 an).";
$l['setting_showlanguageselect'] = "Zeige Sprachwähler?";
$l['setting_showlanguageselect_desc'] = "Hier kannst du das Menü zur Sprachauswahl im Footer aktivieren oder deaktivieren. Wenn nur ein Sprachpaket installiert ist, wird diese Einstellung ignoriert.";
$l['setting_showthemeselect'] = "Zeige Themewähler?";
$l['setting_showthemeselect_desc'] = "Deaktiviere diese Option, wenn du keine Theme-Auswahl im Footer angezeigt haben willst.";
$l['setting_maxmultipagelinks'] = "Maximale Anzahl von Links bei der Seitenanzeige";
$l['setting_maxmultipagelinks_desc'] = "Anzahl der Links zu Seiten bei der Seitenanzeige, wenn mehr als eine Seite gefunden wurde (0 = Keine Beschränkung).";
$l['setting_jumptopagemultipage'] = "Zeige Seitenwähler in Navigation";
$l['setting_jumptopagemultipage_desc'] = "Soll ein Seitenwähler in der Navigation angezeigt werden, wenn die Seitenanzahl die Anzahl von Links bei der Seitenanzeige überschreitet?";
$l['setting_no_plugins'] = "Alle Plugins ausschalten?";
$l['setting_no_plugins_desc'] = "Aktivieren dieser Option wird alle Plugins ausschalten ohne sie zu deaktivieren oder sie zu deinstallieren. Dies ist das Pendant zum Einfügen von NO_PLUGINS in die inc/init.php.";
$l['setting_soft_delete'] = "Beiträge und Themen verstecken anstatt zu löschen";
$l['setting_soft_delete_desc'] = "Wenn aktiviert, werden von Benutzern gelöschte Beiträge und Themen versteckt und können von Moderatoren wiederhergestellt werden. Ansonsten sind diese Beiträge und Themen unwiederbringlich gelöscht.";
$l['setting_announcementshtml'] = "HTML in Ankündigungen erlauben";
$l['setting_announcementshtml_desc'] = "Erlaubt Moderatoren HTML in Ankündigungen zu aktivieren.";
$l['setting_showownunapproved'] = "Zugriff auf eigene abgewiesene Themen / Beiträge";
$l['setting_showownunapproved_desc'] = "Erlaubt Benutzern ihre eigenen abgewiesenen Themen und Beiträge zu sehen.";
$l['setting_helpsearch'] = "Hilfe-Seiten durchsuchbar?";
$l['setting_helpsearch_desc'] = "Wenn aktiviert, können die Hilfe-Seiten durchsucht werden.";
$l['setting_deleteinvites'] = "Auslaufen alter Gruppeneinladungen";
$l['setting_deleteinvites_desc'] = "Die Anzahl an Tagen bis Gruppeneinladungen auslaufen (0 = Einladungen laufen nicht aus).";
$l['setting_hidewebsite'] = "Verstecke Homepage für Gruppen";
$l['setting_hidewebsite_desc'] = "Wähle die Gruppen, vor denen die Homepages der Benutzer versteckt werden";
$l['setting_hidesignatures'] = "Verstecke Signaturen für Gruppen";
$l['setting_hidesignatures_desc'] = "Wähle die Gruppen, vor denen die Signaturen der Benutzer versteckt werden";
$l['setting_seourls'] = "Suchmaschinenfreundliche URLs aktivieren?";
$l['setting_seourls_desc'] = "Suchmaschinenfreundliche URLs sind kürzer und lassen sich besser merken. Aus \"showthread.php?tid=1\" wird beispielsweise \"thread-1.html\". <b>Sobald diese Option aktiviert ist, muss sich die Datei .htaccess (oder - je nach Webserver - eine vergleichbare Konfigurationsdatei) im Ordner des Forums befinden.</b> Die automatische Erkennung kann auf manchen Servern fehlerhaft sein.";
$l['setting_seourls_auto'] = "Automatische Erkennung";
$l['setting_seourls_yes'] = "Aktivieren";
$l['setting_seourls_no'] = "Deaktivieren";
$l['setting_seourls_archive'] = "Suchmaschinenfreundliche URLs im Archiv aktivieren?";
$l['setting_seourls_archive_desc'] = "Suchmaschinenfreundliche URLs können im Archiv verwendet werden. <strong>Bitte prüfe nach dem Aktivieren dieser Option, ob das Archiv noch vollständig funktioniert.</strong>";
$l['setting_gzipoutput'] = "Benutze GZip-Kompression?";
$l['setting_gzipoutput_desc'] = "Willst Du, dass die Seiten im GZip-Format komprimiert werden, bevor sie an den Browser geschickt werden? Effekt: schnellerer Seitenaufbau und weniger Traffic. Eine höhere Komprimierung belastet den Server stärker.";
$l['setting_gziplevel'] = "GZip Komprimierungs-Level";
$l['setting_gziplevel_desc'] = "Gib das Level der Kompression zwischen 0 und 9 an (0 = Keine Kompression, 9 = Maximale Kompression). Für die meisten Installation ist 4 ein guter Wert.";
$l['setting_nocacheheaders'] = "Sende \"No Cache\"-Header";
$l['setting_nocacheheaders_desc'] = "Mit dieser Option kannst du erzwingen, dass dynamische Seiten von Browsern erneut validiert und nicht von Proxies zwischengespeichert werden.";
$l['setting_redirects'] = "Weiterleitungsseiten aktivieren";
$l['setting_redirects_desc'] = "Hier kannst du einstellen, ob Benutzern eine Weiterleitungsseite angezeigt wird oder ob sie direkt zur entsprechenden Seite gelangen sollen.";
$l['setting_load'] = "*NIX Last-Begrenzung";
$l['setting_load_desc'] = "Schränke die maximale Serverlast ein, bevor das Forum Personen den Zugang sperren muss. Wähle 0, um diese Funktion zu deaktivieren. Das empfohlene Limit ist 5.0.";
$l['setting_tplhtmlcomments'] = "HTML-Kommentare am Anfang/Ende der Ausgabe von Templates?";
$l['setting_tplhtmlcomments_desc'] = "Diese Einstellung aktiviert die Ausgabe von HTML-Kommentaren am Anfang/Ende von Templates.";
$l['setting_use_xmlhttprequest'] = "XMLHttp-Anfragen aktivieren?";
$l['setting_use_xmlhttprequest_desc'] = "Hier kannst du alle XMLHttp-Funktionen (AJAX) aktivieren oder deaktivieren.";
$l['setting_extraadmininfo'] = "Erweiterte Statistiken/Debug Infos";
$l['setting_extraadmininfo_desc'] = "Zeigt Serverlast, Generierungszeit, Speicherausnutzung, etc. unten auf jeder Seite des Forums. Beachte, dass diese Informationen nur für Administratoren sichtbar sind.";
$l['setting_uploadspath'] = "Upload-Pfad";
$l['setting_uploadspath_desc'] = "Der Pfad für alle Uploads deiner Benutzer. Es müssen <b>Schreibrechte</b> (CHMOD 777 auf *nix-Servern) vorhanden sein. Wenn es sich um einen relativen Pfad handelt, wird er als relativ zum MyBB-Stammverzeichnis betrachtet. Standardwert: \"./uploads\" (relativer Pfad).";
$l['setting_useerrorhandling'] = "Fehlerverarbeitung";
$l['setting_useerrorhandling_desc'] = "Hier kannst du die interne Fehlerverarbeitung ein- oder ausschalten. Es wird empfohlen, die Verarbeitung des MyBB zu aktivieren.";
$l['setting_errorlogmedium'] = "Logmedium";
$l['setting_errorlogmedium_desc'] = "Wie sollen Fehler verarbeitet werden?";
$l['setting_errorlogmedium_none'] = "Keine Aktion";
$l['setting_errorlogmedium_log'] = "Fehler loggen";
$l['setting_errorlogmedium_email'] = "E-Mail verschicken";
$l['setting_errorlogmedium_both'] = "Fehler loggen und E-Mail verschicken";
$l['setting_errortypemedium'] = "Fehlerarten";
$l['setting_errortypemedium_desc'] = "Bei welchen Arten von Fehlern sollen detailierte Informationen angezeigt werden? Es wird empfohlen die Warnungen und Fehler in produktiven Umgebungen zu verstecken und stattdessen zu loggen.";
$l['setting_errortypemedium_warning'] = "Warnungen";
$l['setting_errortypemedium_error'] = "Fehler";
$l['setting_errortypemedium_both'] = "Warnungen und Fehler";
$l['setting_errortypemedium_none'] = "Warnungen und Fehler verstecken";
$l['setting_errorloglocation'] = "Logdatei";
$l['setting_errorloglocation_desc'] = "Der Ort, an dem die Logs gespeichert werden.";
$l['setting_enableforumjump'] = "Aktiviere \"Gehe zu Forum\"-Menü?";
$l['setting_enableforumjump_desc'] = "Das \"Gehe zu Forum\"-Menü wird auf jeder Foren- und Themenseite unten angezeigt. Besonders bei vielen Foren kann sich dadurch die Ladezeit der Seiten verlängern. Deaktiviere in diesem Fall das Menü.";
$l['setting_ip_forwarded_check'] = "IP-Adressen untersuchen?";
$l['setting_ip_forwarded_check_desc'] = "Willst du die IP-Adressen auf HTTP_X_FORWARDED_FOR- oder HTTP_X_REAL_IP-Header überprüfen? Wenn du unsicher bist, wähle Nein.";
$l['setting_minifycss'] = "Stylesheets verkleinern?";
$l['setting_minifycss_desc'] = "Sollen die Stylesheets verkleinert werden? Wähle \"Ja\" um Traffic zu sparen und die Ladezeiten zu verringern.";
$l['setting_usecdn'] = "Ein CDN benutzen?";
$l['setting_usecdn_desc'] = "Du kannst ein CDN (Content Delivery Network) verwenden um das Laden von statischen Dateien wie Stylesheets, Javascript und Bildern auszulagern. Soll diese Funktion aktiviert werden?";
$l['setting_cdnurl'] = "URL für statische Dateien";
$l['setting_cdnurl_desc'] = "Wenn du die CDN-Option oberhalb aktiviert hast, dann gib hier bitte die URL ein, von der die statischen Dateien geladen werden sollen. Dies muss eine gültige URL ohne Slash (/) am Ende sein.";
$l['setting_cdnpath'] = "Pfad um statische Dateien zu speichern";
$l['setting_cdnpath_desc'] = "Wenn du die CDN-Option oberhalb aktiviert hast, dann kannst du hier optional den vollständigen Pfad zum Speichern der Dateien eingeben. Dies ist für CDNs mit \"Push\"-Funktion oder lokale Subdomains nützlich. Der Pfad muss ohne Slash (/) am Ende angegeben werden.";
$l['setting_dateformat'] = "Datumsformat";
$l['setting_dateformat_desc'] = "Das Standardformat für das Datum innerhalb deines Forums. Es wird das Format für die PHP-Funktion 'date()' benötigt. Bitte nimm Änderungen nur vor, wenn du weißt, was du tust.";
$l['setting_timeformat'] = "Zeitformat";
$l['setting_timeformat_desc'] = "Das Standardformat für die Zeit innerhalb deines Forums. Es wird das Format für die PHP-Funktion 'date()' benötigt. Bitte nimm Änderungen nur vor, wenn du weißt, was du tust.";
$l['setting_datetimesep'] = "Datums-/Zeit-Trennzeichen";
$l['setting_datetimesep_desc'] = "Wenn das MyBB Datum und Zeit zusammenfügt, wird dies als Trennzeichen verwendet (üblicherweise ein Leerzeichen oder Komma).";
$l['setting_regdateformat'] = "Format des Registrierungsdatums";
$l['setting_regdateformat_desc'] = "Das Format für das Datum der Registrierung eines Benutzers.";
$l['setting_timezoneoffset'] = "Standard-Zeitzone";
$l['setting_timezoneoffset_desc'] = "Hier kannst du die Zeitzone für Gäste und neue Mitglieder wählen.";
$l['setting_dstcorrection'] = "Sommerzeitkorrektur";
$l['setting_dstcorrection_desc'] = "Wenn die Zeitzone korrekt gewählt ist, die Zeit aber um eine Stunde verschoben ist, aktiviere bitte die Sommerzeitkorrektur.";
$l['setting_showdescriptions'] = "Zeige Forenbeschreibungen?";
$l['setting_showdescriptions_desc'] = "Sollen die Beschreibungen der einzelnen Foren angezeigt werden?";
$l['setting_subforumsindex'] = "Anzuzeigende Unterforen";
$l['setting_subforumsindex_desc'] = "Gib die Anzahl der anzuzeigenden Unterforen an. Wähle 0, um die Anzeige zu deaktivieren.";
$l['setting_subforumsstatusicons'] = "Zeige Statusicons der Unterforen?";
$l['setting_subforumsstatusicons_desc'] = "Sollen Statusicons für die Unterforen angezeigt werden, die verdeutlichen, ob ein Forum neue Beiträge enthält? Diese Einstellung tritt nur in Kraft, wenn die Anzeige von Unterforen aktiviert ist.";
$l['setting_hideprivateforums'] = "Private Foren verstecken?";
$l['setting_hideprivateforums_desc'] = "Durch diese Option werden private Foren nicht angezeigt. Die Foren werden dann ebenfalls aus dem \"Gehe zu Forum\"-Menü entfernt.";
$l['setting_modlist'] = "Anzeige der Moderatoren";
$l['setting_modlist_desc'] = "Sollen die Moderatoren der jeweiligen Foren angezeigt werden?";
$l['setting_showbirthdays'] = "Zeige heutige Geburtstage?";
$l['setting_showbirthdays_desc'] = "Sollen die heutigen Geburtstage auf der Startseite angezeigt werden?";
$l['setting_showbirthdayspostlimit'] = "Zeige Geburtstage erst ab x Beiträgen";
$l['setting_showbirthdayspostlimit_desc'] = "Du kannst auswählen, dass nur die Geburtstage von Benutzern mit mehr als der angegebenen Beitragsanzahl angezeigt werden. Die Einstellung 0 zeigt die heutigen Geburtstage von allen Benutzern.";
$l['setting_showwol'] = "Zeige wer online ist?";
$l['setting_showwol_desc'] = "Sollen die angemeldeten Benutzer auf der Startseite angezeigt werden?";
$l['setting_showindexstats'] = "Zeige Statistik?";
$l['setting_showindexstats_desc'] = "Soll eine kleine Statistik des Forums auf der Startseite angezeigt werden?";
$l['setting_showforumviewing'] = "Zeige Anzahl der Benutzer in Foren?";
$l['setting_showforumviewing_desc'] = "Soll angezeigt werden, wie viele Benutzer in den einzelnen Foren aktiv sind?";
$l['setting_threadsperpage'] = "Themen pro Seite";
$l['setting_threadsperpage_desc'] = "Gib die Anzahl der Themen an, die pro Seite angezeigt werden sollen.";
$l['setting_hottopic'] = "Anzahl der Antworten für \"Heißes Thema\"";
$l['setting_hottopic_desc'] = "Gib an, ab welcher Anzahl an Antworten ein Thema als \"heiß\" markiert werden soll.";
$l['setting_hottopicviews'] = "Anzahl der Ansichten für \"Heißes Thema\"";
$l['setting_hottopicviews_desc'] = "Gib an, ab welcher Anzahl an Ansichten ein Thema als \"heiß\" markiert werden soll.";
$l['setting_usertppoptions'] = "Auswählbare Anzahl an Themen pro Seite";
$l['setting_usertppoptions_desc'] = "Wenn die Benutzer auswählen dürfen, wie viele Themen pro Seite angezeigt werden sollen, gib die Wahlmöglichkeiten durch Kommas getrennt an. Ist das Feld leer, haben Benutzer nicht die Möglichkeit, zu wählen.";
$l['setting_dotfolders'] = "\"Punkt\"-Icons verwenden";
$l['setting_dotfolders_desc'] = "Sollen auf der Themenseite Themen hervorgehoben werden, in denen ein Benutzer aktiv war?";
$l['setting_allowthreadratings'] = "Erlaube Themen-Bewertungen?";
$l['setting_allowthreadratings_desc'] = "Benutzer dürfen Themen bewerten?";
$l['setting_browsingthisforum'] = "Benutzer in diesem Forum";
$l['setting_browsingthisforum_desc'] = "Hier kannst du auswählen, ob angezeigt werden soll, welche Benutzer sich in einem Forum befinden.";
$l['setting_announcementlimit'] = "Ankündigungsbegrenzung";
$l['setting_announcementlimit_desc'] = "Gib die Anzahl der max. anzuzeigenden Ankündigungen an. Wähle 0, um die Anzeige komplett zu deaktivieren.";
$l['setting_readparentforums'] = "Versuche Eltern-Foren als gelesen zu markieren";
$l['setting_readparentforums_desc'] = "Wenn ja, wird versucht die Eltern-Foren als gelesen zu markieren, wenn es keine ungelesenen Themen gibt. Bitte beachte, dass diese Einstellung die Performance negativ beeinflussen könnte und deshalb als experimentell angesehen wird.";
$l['setting_postlayout'] = "Beitragslayout";
$l['setting_postlayout_desc'] = "Diese Option erlaubt es dir, zwischen der klassischen vertikalen und der neuen horizontalen Ansicht zu wechseln. In der klassischen Ansicht werden die Informationen zum Autor neben, in der neuen Ansicht über dem Beitrag angezeigt.";
$l['setting_postlayout_horizontal'] = "Benutze das horizontale Layout (neu)";
$l['setting_postlayout_classic'] = "Benutze das vertikale Layout (klassisch)";
$l['setting_postsperpage'] = "Beiträge pro Seite";
$l['setting_postsperpage_desc'] = "Die Anzahl der Beiträge, die pro Seite angezeigt werden. Wir empfehlen höchstens 20 zu wählen, damit auch Benutzer mit einer langsamen Internetverbindung das Forum ohne Probleme benutzen können.";
$l['setting_userpppoptions'] = "Wählbare Beiträge pro Seite";
$l['setting_userpppoptions_desc'] = "Wenn du deinen Benutzern erlauben willst, auszuwählen, wie viele Beiträge auf einer Seite angezeigt werden, gib hier die Optionen durch Kommas getrennt an. Bleibt das Feld leer, können die Benutzer die Anzahl der Beiträge nicht selbst auswählen.";
$l['setting_postmaxavatarsize'] = "Maximale Avatar-Größe";
$l['setting_postmaxavatarsize_desc'] = "Gib die maximale Größe für Avatare neben den Beiträgen an (Breite und Höhe getrennt durch 'x' oder '|'). Zu große Avatare werden automatisch verkleinert.";
$l['setting_threadreadcut'] = "Gelesene Themen in Datenbank";
$l['setting_threadreadcut_desc'] = "Die Anzahl der Tage, für die Informationen über gelesene Themen in der Datenbank gespeichert werden sollen. Für große Foren empfehlen wir, die Zahl nicht zu groß zu wählen, da das Forum sonst langsamer werden kann (0 = Deaktiviert).";
$l['setting_threadusenetstyle'] = "Themenanzeige im Usenet-Stil";
$l['setting_threadusenetstyle_desc'] = "Wähle \"Ja\", wenn du willst, dass die Themen wie im Usenet angezeigt werden.";
$l['setting_quickreply'] = "Zeige Schnellantwort-Box";
$l['setting_quickreply_desc'] = "Soll die Schnellantwort-Box unter Themen angezeigt werden soll.";
$l['setting_multiquote'] = "Zeige Multizitier-Buttons?";
$l['setting_multiquote_desc'] = "Multizitier-Buttons erlauben das Zitieren von mehreren Beiträgen in einer neuen Antwort.";
$l['setting_showsimilarthreads'] = "Zeige \"Ähnliche Themen\"-Tabelle?";
$l['setting_showsimilarthreads_desc'] = "Die \"Ähnliche Themen\"-Tabelle zeigt Themen, die mit dem Thema, das gerade gelesen wird, Ähnlichkeiten haben. Unten kannst du die Relevanz einstellen.";
$l['setting_similarityrating'] = "Ähnliche Themen-Relevanz";
$l['setting_similarityrating_desc'] = "Hier kannst du festlegen, wie relevant bestimmte Themen sind (0 = nicht relevant). Diese Zahl sollte nicht größer sein als 10; für größere Foren aber auch nicht zu klein (<5) gewählt werden. Dies funktioniert nicht mit PgSQL.";
$l['setting_similarlimit'] = "Ähnliche Themen-Anzahl";
$l['setting_similarlimit_desc'] = "Die Anzahl der Themen, die in der Tabelle angezeigt werden. Wir empfehlen, höchstens 15 zu wählen.";
$l['setting_showforumpagesbreadcrumb'] = "Zeige Dropdown-Menü mit den Foren-Seitenzahlen?";
$l['setting_showforumpagesbreadcrumb_desc'] = "Wenn ein Forum mehr als eine Seite hat, soll dann ein Dropdown-Menü mit den Seitenzahlen in der Navigation angezeigt werden?";
$l['setting_browsingthisthread'] = "Benutzer, die ein Thema betrachten";
$l['setting_browsingthisthread_desc'] = "Hier kann die Anzeige der Benutzer, die ein Thema betrachten, deaktiviert werden.";
$l['setting_delayedthreadviews'] = "Verzögerte Aktualisierung der Themenansichten";
$l['setting_delayedthreadviews_desc'] = "Ist diese Option aktiviert, werden die Themenansichten im Hintergrund durch das Aufgabensystem aktualisiert. Andernfalls werden die Ansichten ohne Verzögerung gezählt.";
$l['setting_threadviews_countspiders'] = "Themenansichten bei Besuchen von Bots erhöhen?";
$l['setting_threadviews_countspiders_desc'] = "Hier kannst du Ansichten von Bots bei den Themenansichten einschließen.";
$l['setting_threadviews_countguests'] = "Themenansichten bei Besuchen von Gästen erhöhen?";
$l['setting_threadviews_countguests_desc'] = "Hier kannst du Ansichten von Gästen bei den Themenansichten einschließen.";
$l['setting_threadviews_countthreadauthor'] = "Themenansichten bei Besuchen des Autor erhöhen?";
$l['setting_threadviews_countthreadauthor_desc'] = "Hier kannst du Ansichten vom Autor des Themas bei den Themenansichten einschließen.";
$l['setting_disableregs'] = "Registrierungen deaktivieren";
$l['setting_disableregs_desc'] = "Hier kannst du bestimmen, ob Registrierungen möglich sind oder nicht.";
$l['setting_regtype'] = "Registrierungsmethode";
$l['setting_regtype_desc'] = "Wähle hier die Art, wie die Registrierung erfolgen soll.";
$l['setting_regtype_instant'] = "Benutzer sofort freischalten";
$l['setting_regtype_verify'] = "E-Mail-Bestätigung verschicken";
$l['setting_regtype_randompass'] = "Zufallsgeneriertes Passwort verschicken";
$l['setting_regtype_admin'] = "Freischaltung durch Administrator";
$l['setting_regtype_both'] = "E-Mail-Bestätigung & Freischaltung durch Administrator";
$l['setting_awactialert'] = "Benachrichtigung über nicht aktivierte Benutzer";
$l['setting_awactialert_desc'] = "Soll Administratoren im Forum ein Hinweis über nicht aktivierte Benutzer angezeigt werden?";
$l['setting_forcelogin'] = "Login erzwingen";
$l['setting_forcelogin_desc'] = "Mit dieser Einstellung kannst du auswählen, ob Benutzer sich anmelden oder registrieren müssen um auf das Forum zugreifen zu können.";
$l['setting_minnamelength'] = "Minimale Benutzernamenlänge";
$l['setting_minnamelength_desc'] = "Die minimale Anzahl an Zeichen, aus denen ein Benutzername bei der Registrierung bestehen muss.";
$l['setting_maxnamelength'] = "Maximale Benutzernamenlänge";
$l['setting_maxnamelength_desc'] = "Die maximale Anzahl an Zeichen für Benutzernamen.";
$l['setting_minpasswordlength'] = "Minimale Passwortlänge";
$l['setting_minpasswordlength_desc'] = "Die minimale Anzahl an Zeichen für Passwörter.";
$l['setting_maxpasswordlength'] = "Maximale Passwortlänge";
$l['setting_maxpasswordlength_desc'] = "Die maximale Anzahl an Zeichen für Passwörter.";
$l['setting_requirecomplexpasswords'] = "Benötigt ein komplexes Passwort?";
$l['setting_requirecomplexpasswords_desc'] = "Sollen die Benutzer ein komplexes Passwort benutzen müssen? Komplexe Passwörter bestehen aus großen Buchstaben, kleinen Buchstaben und Zahlen.";
$l['setting_betweenregstime'] = "Zeit zwischen Registrierungen";
$l['setting_betweenregstime_desc'] = "Die Zeit (in Stunden), die ein Benutzer warten muss, bevor er sich unter der gleichen IP-Adresse einen weiteren Account anlegen kann.  Wähle 0, um diese Funktion zu deaktivieren.";
$l['setting_maxregsbetweentime'] = "Maximale Registrierungen pro IP-Adresse";
$l['setting_maxregsbetweentime_desc'] = "Diese Option erlaubt es dir, die maximale Anzahl an Registrierungen festzulegen, die ein Benutzer unter einer IP-Adresse im o. a. Zeitrahmen durchführen darf.";
$l['setting_allowmultipleemails'] = "Erlaube mehrfache Registrierung mit der gleichen E-Mail-Adresse?";
$l['setting_allowmultipleemails_desc'] = "Wähle \"Ja\", wenn du mehrfache Registrierungen mit der gleichen E-Mail-Adresse erlauben willst.";
$l['setting_emailkeep'] = "Benutzer können E-Mail-Adresse behalten";
$l['setting_emailkeep_desc'] = "Darf ein Benutzer, der unter einer ausgeschlossenen E-Mail-Adresse bereits registriert ist, diese Adresse behalten?";
$l['setting_hiddencaptchaimage'] = "Zeige ein verstecktes Captcha";
$l['setting_hiddencaptchaimage_desc'] = "Soll ein verstecktes Bestätigungsfeld bei der Registrierung angezeigt werden? Dies kann Spambots von der Registrierung abhalten.";
$l['setting_hiddencaptchaimagefield'] = "Verstecktes Captcha-Feld";
$l['setting_hiddencaptchaimagefield_desc'] = "Hier kannst du den Namen des versteckten Captcha-Felds wählen.";
$l['setting_usereferrals'] = "Benutze Referrer-System";
$l['setting_usereferrals_desc'] = "Soll in diesem Forum das Referrer-System benutzt werden?";
$l['setting_referralsperpage'] = "Empfehlungen pro Seite";
$l['setting_referralsperpage_desc'] = "Die Anzahl der Benutzer, die pro Seite auf der Empfehlungsliste angezeigt werden sollen.";
$l['setting_coppa'] = "COPPA Einwilligung";
$l['setting_coppa_desc'] = "Hier kannst du die <a href=\"https://www.ftc.gov/enforcement/rules/rulemaking-regulatory-reform-proceedings/childrens-online-privacy-protection-rule\" target=\"_blank\">COPPA</a>-Unterstützung ein- und ausschalten.";
$l['setting_coppa_enabled'] = "Aktiviert";
$l['setting_coppa_deny'] = "Zugriff für unter 13jährige verweigern";
$l['setting_coppa_disabled'] = "Deaktiviert";
$l['setting_username_method'] = "Erlaubte Login-Methoden";
$l['setting_username_method_desc'] = "Die erlaubten Eingaben für das Login-Feld Benutzername. Nur Benutzername, nur E-Mail-Adresse oder beides.<br />Damit sich Benutzer mit der E-Mail-Adresse anmelden können, dürfen keine die selbe E-Mail-Adresse verwenden.";
$l['setting_username_method_0'] = "Nur Benutzername";
$l['setting_username_method_1'] = "Nur E-Mail-Adresse";
$l['setting_username_method_2'] = "Benutzername oder E-Mail-Adresse";
$l['setting_failedcaptchalogincount'] = "Anzahl der Anmeldeversuche, nach denen ein Captcha gezeigt wird";
$l['setting_failedcaptchalogincount_desc'] = "Nach wie vielen fehlgeschlagenen Anmeldeversuchen ist eine Captcha-Überprüfung erforderlich (0 = deaktiviert)?";
$l['setting_failedlogincount'] = "Anzahl der Login-Versuche";
$l['setting_failedlogincount_desc'] = "Die Anzahl der Login-Versuche, nach denen ein Benutzer für die unten wählbare Zeit keinen weiteren Login vornehmen kann. Wähle 0, um diese Funktion zu deaktivieren.";
$l['setting_failedlogintime'] = "Zeit zwischen Login-Versuchen";
$l['setting_failedlogintime_desc'] = "Die Wartezeit nach fehlgeschlagenen Logins (Minuten). Diese Einstellung wird nur verwendet, wenn der Wert in der vorigen Einstellung größer ist als 0.";
$l['setting_failedlogintext'] = "Anzahl fehlgeschlagener Logins zeigen?";
$l['setting_failedlogintext_desc'] = "Soll den Benutzern angezeigt werden, wie viele Login-Versuche ihnen noch bleiben?";
$l['setting_regtime'] = "Minimale Dauer der Registrierung";
$l['setting_regtime_desc'] = "Die minimale Dauer in Sekunden, die zum Ausfüllen des Registrierungsformulars benötigt werden muss. Dies hilft gegen automatische Registrierungs-Bots (0 = keine Beschränkung).";
$l['setting_securityquestion'] = "Zeige Sicherheitsfragen";
$l['setting_securityquestion_desc'] = "Sollen neue Benutzer bei der Registrierung eine Sicherheitsfrage beantworten müssen?";
$l['setting_sigmycode'] = "MyCode in Signaturen";
$l['setting_sigmycode_desc'] = "Willst du Benutzern erlauben, MyCode in ihren Signaturen zu verwenden?";
$l['setting_sigcountmycode'] = "Behandlung von MyCode in Signaturen";
$l['setting_sigcountmycode_desc'] = "Soll MyCode zur Signaturlänge hinzugezählt werden?";
$l['setting_sigsmilies'] = "Smilies in Signaturen";
$l['setting_sigsmilies_desc'] = "Dürfen Benutzer Smilies in ihren Signaturen verwenden?";
$l['setting_sightml'] = "HTML in Signaturen";
$l['setting_sightml_desc'] = "Dürfen Benutzer HTML-Code in ihren Signaturen verwenden?";
$l['setting_sigimgcode'] = "[img]-Code in Signaturen";
$l['setting_sigimgcode_desc'] = "Dürfen Benutzer [img]-Code in ihren Signaturen verwenden?";
$l['setting_maxsigimages'] = "Maximale Bildanzahl pro Signatur";
$l['setting_maxsigimages_desc'] = "Gib die maximal zulässige Zahl an Bildern (inklusive Smilies) ein, die ein Benutzer pro Signatur verwenden darf (0 = Bilder komplett deaktivieren).";
$l['setting_siglength'] = "Limit für Signaturen";
$l['setting_siglength_desc'] = "Die maximal erlaubte Zeichenanzahl in einer Signatur (0 = Keine Beschränkung).";
$l['setting_useravatar'] = "Standard-Avatar";
$l['setting_useravatar_desc'] = "Wenn ein Benutzer kein eigenes Avatar eingerichtet hat, wird stattdessen dieses Bild angezeigt. Falls du für verschiedene Themes unterschiedliche Bilder verwenden möchtest, verwende bitte <strong>{theme}</strong> als Platzhalter für das Theme im Pfad.";
$l['setting_useravatardims'] = "Standard-Avatar-Größe";
$l['setting_useravatardims_desc'] = "Die Abmessungen des Standard-Avatars; Breite und Höhe getrennt durch 'x' oder '|' (z.B. 40|40 oder 40x40).";
$l['setting_useravatarrating'] = "Gravatar Einstufung";
$l['setting_useravatarrating_desc'] = "Erlaubt eine die benötigte Einstufung von Avataren von Gravatar einzustellen. Wenn ein Avatar eines Benutzers eine höhere Einstufung hat, wird das Standard-Avatar angezeigt. Die Einstufungen sind:
<ul>
<li><strong>G</strong>: geeignet für Websites mit allen Besuchern</li>
<li><strong>PG</strong>: kann unanständige Gesten, provokativ angezogene Leute, Schimpfwörter oder leichte Gewalt zeigen</li>
<li><strong>R</strong>: kann Dinge Obszönitäten, intensive Gewalt, Nacktheit oder Drogenkonsum zeigen</li>
<li><strong>X</strong>: kann Hardcore-Pornographie oder extreme Gewalt zeigen</li>
</ul>";
$l['setting_useravatarrating_g'] = "G";
$l['setting_useravatarrating_pg'] = "PG";
$l['setting_useravatarrating_r'] = "R";
$l['setting_useravatarrating_x'] = "X";
$l['setting_maxavatardims'] = "Maximale Avatar-Größe";
$l['setting_maxavatardims_desc'] = "Die maximal zulässige Größe für Avatare, Breite und Höhe getrennt durch 'x' oder '|'. Wenn das Feld leer bleibt, wird die Größe nicht beschränkt.";
$l['setting_avatarsize'] = "Maximale Avatar-Größe";
$l['setting_avatarsize_desc'] = "Die maximale Dateigröße (in Kilobyte) für hochgeladene Avatare (0 = Keine Beschränkung).";
$l['setting_avatarresizing'] = "Automatische Avatarverkleinerung";
$l['setting_avatarresizing_desc'] = "Hier kannst du wählen, ob zu große Avatare automatisch verkleinert werden sollen.";
$l['setting_avatarresizing_auto'] = "Automatische Avatarverkleinerung";
$l['setting_avatarresizing_user'] = "Benutzer kann Verkleinerung wählen";
$l['setting_avatarresizing_disabled'] = "Diese Funktion deaktivieren";
$l['setting_avataruploadpath'] = "Avatar Upload-Pfad";
$l['setting_avataruploadpath_desc'] = "Der Pfad für von Benutzern hochgeladene Avatare. Es müssen <b>Schreibrechte</b> (CHMOD 777 auf Unix-Servern) vorhanden sein.";
$l['setting_allowremoteavatars'] = "Erlaube externe Avatare";
$l['setting_allowremoteavatars_desc'] = "Soll die Verwendung von externen Avataren erlaubt sein? Dies kann die IP-Adresse des Servers verraten.";
$l['setting_customtitlemaxlength'] = "Maximale Länge eines eigenen Benutzertitels";
$l['setting_customtitlemaxlength_desc'] = "Die maximal zulässige Länge des Benutzertitels, den ein Benutzer selbst wählen kann (0 = Keine Beschränkung).";
$l['setting_allowaway'] = "Erlaube Abwesenheits-Status?";
$l['setting_allowaway_desc'] = "Dürfen Benutzer den Status \"Abwesend\" wählen und einen Grund und das Datum der Wiederkehr angeben?";
$l['setting_allowbuddyonly'] = "Erlaube Nachrichten nur an Freunde?";
$l['setting_allowbuddyonly_desc'] = "Sollen Benutzer private Nachrichten nur an Benutzer schicken dürfen, die sich auf ihrer Freundesliste befinden?";
$l['setting_minmessagelength'] = "Minimale Nachrichtenlänge";
$l['setting_minmessagelength_desc'] = "Die minimal benötigte Anzahl an Zeichen eines Beitrags.";
$l['setting_maxmessagelength'] = "Maximale Nachrichtenlänge";
$l['setting_maxmessagelength_desc'] = "Die maximal zulässige Anzahl an Zeichen (Bytes) in einer Nachricht (0 = Beschränkung durch Datenbank).
<br />Tipp: MySQL-Benutzer (Maximum: 65535) können manuell den Typ der Spalte 'message' von TEXT auf MEDIUMTEXT (16777215) oder LONGTEXT (4294967295) ändern um das Limit zu erhöhen.";
$l['setting_mycodemessagelength'] = "MyCode wird bei der minimalen Beitragslänge beachtet?";
$l['setting_mycodemessagelength_desc'] = "Soll MyCode bei der minimalen Beitragslänge in Nachrichten gezählt werden?";
$l['setting_postfloodcheck'] = "Zeit zwischen Beiträgen";
$l['setting_postfloodcheck_desc'] = "Wähle diese Einstellung, wenn zwischen der Erstellung von einzelnen Beiträgen eines Benutzers ein bestimmter Zeitraum vergehen muss (Flood-Control). Gib die Zeit unten an.";
$l['setting_postfloodsecs'] = "Zeiteinstellung";
$l['setting_postfloodsecs_desc'] = "Die Zeit (in Sekunden), die Benutzer zwischen der Beitragserstellung warten müssen; die Option dazu muss aktiviert sein.";
$l['setting_postmergemins'] = "Beiträge automatisch zusammenfügen";
$l['setting_postmergemins_desc'] = "Ist diese Einstellung aktiviert, werden Beiträge, die innerhalb von x Minuten von dem selben Benutzer verfasst wurden, automatisch zusammengefügt. Gib die Minuten an oder wähle 0, um diese Funktion zu deaktivieren.";
$l['setting_postmergefignore'] = "Foren vom Zusammenfügen ausschließen";
$l['setting_postmergefignore_desc'] = "Gib die Foren an, in denen Beiträge nicht automatisch zusammengefügt werden sollen. Lasse das Feld leer um die Funktion zu deaktivieren.";
$l['setting_postmergeuignore'] = "Benutzergruppen vom Zusammenfügen ausschließen";
$l['setting_postmergeuignore_desc'] = "Wähle die Benutzergruppen aus, deren Beiträge nicht automatisch zusammengefügt werden sollen.";
$l['setting_postmergesep'] = "Beitragstrenner";
$l['setting_postmergesep_desc'] = "Das Trennzeichen, das automatisch zusammengefügte Beiträge voneinander trennt. Standard: [hr].";
$l['setting_logip'] = "Zeige IP-Adressen in Beiträgen";
$l['setting_logip_desc'] = "Hier kannst du einstellen, ob die IP-Adressen der Benutzer in ihren Beiträgen angezeigt werden sollen und wer sie sehen kann.";
$l['setting_logip_no'] = "IPs nicht anzeigen";
$l['setting_logip_hide'] = "Sichtbar für Administratoren & Moderatoren";
$l['setting_logip_show'] = "Sichtbar für alle Benutzer";
$l['setting_showeditedby'] = "Zeige \"Bearbeitet von\" bei gewöhnlichen Benutzern";
$l['setting_showeditedby_desc'] = "Zeigt eine \"Bearbeitet von\"-Nachrichten an, wenn ein Beitrag bearbeitet wurde, der von einem gewöhnlichen Benutzer verfasst wurde.";
$l['setting_showeditedbyadmin'] = "Zeige \"Bearbeitet von\" bei Foren-Team";
$l['setting_showeditedbyadmin_desc'] = "Zeigt eine \"Bearbeitet von\"-Nachrichten an, wenn ein Beitrag bearbeitet wurde, der von einem Administrator oder Moderator verfasst wurde.";
$l['setting_maxpostimages'] = "Maximale Bildanzahl pro Beitrag";
$l['setting_maxpostimages_desc'] = "Gib die maximal zulässige Zahl an Bildern (inklusive Smilies) ein, die ein Benutzer pro Beitrag verwenden darf (0 = Keine Begrenzung).";
$l['setting_maxpostvideos'] = "Maximale Anzahl Videos pro Beitrag";
$l['setting_maxpostvideos_desc'] = "Wie viele Videos darf ein Benutzer pro Beitrag einbinden (0 = deaktiviert)?";
$l['setting_subscribeexcerpt'] = "Anzahl der Zeichen für abonnierte Themen-E-Mails";
$l['setting_subscribeexcerpt_desc'] = "Wie viele Zeichen eines Beitrags sollen in der Vorschau in einer E-Mail verschickt werden, wenn eine neue Antwort geschrieben wurde?";
$l['setting_maxquotedepth'] = "Maximale Anzahl an eingebetteten Zitaten";
$l['setting_maxquotedepth_desc'] = "Die maximal zulässige Tiefe für Zitate. Wenn ein Beitrag durch Zitieren beantwortet wird, werden alle Zitate, welche das Limit überschreiten, automatisch entfernt. Beachte, dass die Entfernung nur durchgeführt wird, wenn zitierend geantwortet wird, und dass bestehende Beiträge nicht betroffen sind (0 = deaktiviert).";
$l['setting_polloptionlimit'] = "Maximale Länge von Umfrage-Optionen";
$l['setting_polloptionlimit_desc'] = "Die maximale Länge jeder Umfrage-Option (0 = Keine Begrenzung).";
$l['setting_maxpolloptions'] = "Maximale Anzahl von Umfrageantworten";
$l['setting_maxpolloptions_desc'] = "Die maximale Anzahl von Antwortmöglichkeiten bei Umfragen (0 = Keine Begrenzung).";
$l['setting_polltimelimit'] = "Zeitlimit für Umfragen";
$l['setting_polltimelimit_desc'] = "Die Anzahl an Stunden, nach denen ein normaler Benutzer in seinen Themen keine Umfragen mehr erstellen kann, sofern dies die Berechtigungen erlauben (0 = Keine Begrenzung).";
$l['setting_threadreview'] = "Zeige letzte Beiträge";
$l['setting_threadreview_desc'] = "Sollen die letzten Beiträge angezeigt werden, wenn auf ein Thema geantwortet wird?";
$l['setting_alloweditreason'] = "Bearbeitungsgrund erlauben";
$l['setting_alloweditreason_desc'] = "Willst du den Benutzern erlauben einen Grund für die Bearbeitung von Beiträgen angeben zu können?";
$l['setting_enableattachments'] = "Aktiviere Attachment-System";
$l['setting_enableattachments_desc'] = "Wenn du Attachments im Forum verbieten willst, wähle \"Nein\".";
$l['setting_maxattachments'] = "Maximale Attachments pro Beitrag";
$l['setting_maxattachments_desc'] = "Die maximal zulässige Anzahl von Attachments pro Beitrag.";
$l['setting_attachthumbnails'] = "Zeige Thumbnails in Beiträgen?";
$l['setting_attachthumbnails_desc'] = "Wie sollen Bilder in Beiträgen angezeigt werden?";
$l['setting_attachthumbnails_yes'] = "Thumbnail";
$l['setting_attachthumbnails_no'] = "Bild in voller Größe";
$l['setting_attachthumbnails_download'] = "Download";
$l['setting_attachthumbh'] = "Maximale Thumbnail-Höhe";
$l['setting_attachthumbh_desc'] = "Gib die max. Höhe der Thumbnails ein, die von angehängten Bildern generiert werden sollen.";
$l['setting_attachthumbw'] = "Maximale Thumbnail-Breite";
$l['setting_attachthumbw_desc'] = "Gib die max. Breite der Thumbnails ein, die von angehängten Bildern generiert werden sollen.";
$l['setting_enablememberlist'] = "Mitgliederliste aktivieren?";
$l['setting_enablememberlist_desc'] = "Hier kannst du die Mitgliederliste ein- und ausschalten.";
$l['setting_membersperpage'] = "Mitglieder pro Seite";
$l['setting_membersperpage_desc'] = "Die Anzahl der Mitglieder pro Seite in der Mitgliederliste.";
$l['setting_default_memberlist_sortby'] = "Standardsortierung";
$l['setting_default_memberlist_sortby_desc'] = "Wähle das Feld, nach dem die Benutzer standardmäßig sortiert werden sollen.";
$l['setting_default_memberlist_sortby_regdate'] = "Registrierungsdatum";
$l['setting_default_memberlist_sortby_postnum'] = "Beitragsanzahl";
$l['setting_default_memberlist_sortby_username'] = "Benutzername";
$l['setting_default_memberlist_sortby_lastvisit'] = "Letzter Besuch";
$l['setting_default_memberlist_order'] = "Standard Reihenfolge";
$l['setting_default_memberlist_order_desc'] = "Wähle die Reihenfolge, in der die Mitglieder standardmäßig angezeigt werden sollen.<br />Aufsteigend: A-Z / Anfang-Ende<br />Absteigend: Z-A / Ende-Anfang";
$l['setting_default_memberlist_order_ascending'] = "Aufsteigend";
$l['setting_default_memberlist_order_descending'] = "Absteigend";
$l['setting_memberlistmaxavatarsize'] = "Maximale Avatar-Größe";
$l['setting_memberlistmaxavatarsize_desc'] = "Gib die maximale Größe für anzuzeigende Avatare an (Breite und Höhe getrennt durch 'x' oder '|'). Zu große Avatare werden automatisch verkleinert.";
$l['setting_enablereputation'] = "Bewertungssystem aktivieren?";
$l['setting_enablereputation_desc'] = "Wähle \"Nein\", wenn das Bewertungssystem in deinem Forum ausgeschaltet werden soll.";
$l['setting_posrep'] = "Positive Bewertungen erlauben";
$l['setting_posrep_desc'] = "Sollen Benutzer andere Benutzer positiv bewerten dürfen?";
$l['setting_negrep'] = "Negative Bewertungen erlauben";
$l['setting_negrep_desc'] = "Sollen Benutzer andere Benutzer negativ bewerten dürfen?";
$l['setting_neurep'] = "Neutrale Bewertungen erlauben";
$l['setting_neurep_desc'] = "Sollen Benutzer andere Benutzer neutral bewerten dürfen?";
$l['setting_multirep'] = "Mehrfache Bewertungen erlauben";
$l['setting_multirep_desc'] = "Sollen Benutzer andere Benutzer mehrfach bewerten dürfen?";
$l['setting_postrep'] = "Beitragsbewertungen erlauben";
$l['setting_postrep_desc'] = "Sollen Bewertungen mit Beiträgen verknüpft werden können?";
$l['setting_repsperpage'] = "Bewertungskommentare pro Seite";
$l['setting_repsperpage_desc'] = "Hier kannst du die Anzahl der Bewertungskommentare eingeben, die auf einer Seite angezeigt werden sollen.";
$l['setting_maxreplength'] = "Maximale Länge einer Bewertung";
$l['setting_maxreplength_desc'] = "Die maximal erlaubte Anzahl an Zeichen einer Bewertung.";
$l['setting_minreplength'] = "Minimale Länge einer Bewertung";
$l['setting_minreplength_desc'] = "Die minimal erlaubte Anzahl an Zeichen einer Bewertung.";
$l['setting_enablewarningsystem'] = "Warnsystem aktivieren?";
$l['setting_enablewarningsystem_desc'] = "Wähle \"Nein\", um das System auszuschalten.";
$l['setting_allowcustomwarnings'] = "Erlaube eigene Warnungen?";
$l['setting_allowcustomwarnings_desc'] = "Darf ein Benutzer einen Grund und eine Anzahl von Punkten angeben, ohne auf die definierten Warntypen zurückgreifen zu müssen?";
$l['setting_canviewownwarning'] = "Benutzer können eigene Verwarnungen sehen?";
$l['setting_canviewownwarning_desc'] = "Dürfen Benutzer ihre letzten Verwarnungen im Benutzer-CP und ihr Warnlevel im Profil sehen?";
$l['setting_allowanonwarningpms'] = "Erlaube anonyme Warnungs-PNs";
$l['setting_allowanonwarningpms_desc'] = "Dürfen Moderatoren bei Warnungen anonyme Warnungs-PNs senden?";
$l['setting_maxwarningpoints'] = "Maximale Warnpunkte";
$l['setting_maxwarningpoints_desc'] = "Gib die Anzahl der Punkte ein, bei denen ein Warnlevel von 100% erreicht ist.";
$l['setting_enablepms'] = "Private Nachrichten-System aktivieren?";
$l['setting_enablepms_desc'] = "Wähle \"Nein\", wenn das Private Nachrichten-System in deinem Forum ausgeschaltet werden soll.";
$l['setting_pmquickreply'] = "Zeige Schnellantwort-Box";
$l['setting_pmquickreply_desc'] = "Erlaubt dir einzustellen, ob die Schnellantwort-Box unterhalb der Privaten Nachrichten angezeigt werden soll oder nicht.";
$l['setting_pmsallowhtml'] = "HTML erlauben";
$l['setting_pmsallowhtml_desc'] = "Hier kannst du einstellen, ob die Benutzer HTML-Code in privaten Nachrichten verwenden dürfen.";
$l['setting_pmsallowmycode'] = "MyCode erlauben";
$l['setting_pmsallowmycode_desc'] = "Hier kannst du einstellen, ob die Benutzer MyCode in privaten Nachrichten verwenden dürfen.";
$l['setting_pmsallowsmilies'] = "Smilies erlauben";
$l['setting_pmsallowsmilies_desc'] = "Hier kannst du einstellen, ob die Benutzer Smilies in privaten Nachrichten verwenden dürfen.";
$l['setting_pmsallowimgcode'] = "[img]-Code erlauben";
$l['setting_pmsallowimgcode_desc'] = "Hier kannst du einstellen, ob die Benutzer [img]-Code in privaten Nachrichten verwenden dürfen.";
$l['setting_pmsallowvideocode'] = "[video]-Code erlauben";
$l['setting_pmsallowvideocode_desc'] = "Falls aktiviert kann [video] in privaten Nachrichten benutzt werden.";
$l['setting_pmfloodsecs'] = "Wartezeit für private Nachrichten";
$l['setting_pmfloodsecs_desc'] = "Gib die Zeit in Sekunden an, die ein Benutzer zwischen dem Versand von privaten Nachrichten warten muss (0 = deaktiviert).";
$l['setting_showpmip'] = "Zeige IP-Adressen in Privaten Nachrichten";
$l['setting_showpmip_desc'] = "Hier kannst du einstellen, ob die IP-Adressen der Benutzer in ihren Privaten Nachrichten angezeigt werden sollen und wer sie sehen kann.";
$l['setting_showpmip_no'] = "IPs nicht anzeigen";
$l['setting_showpmip_hide'] = "Sichtbar für Administratoren & Moderatoren";
$l['setting_showpmip_show'] = "Sichtbar für alle Benutzer";
$l['setting_maxpmquotedepth'] = "Maximale Anzahl an eingebetteten Zitaten in Private Nachrichten";
$l['setting_maxpmquotedepth_desc'] = "Die maximal zulässige Tiefe für Zitate. Wenn eine Private Nachricht durch Zitieren beantwortet wird, werden alle Zitate, welche das Limit überschreiten, automatisch entfernt. Beachten Sie, dass die Entfernung nur durchgeführt wird, wenn zitierend geantwortet wird, und dass bestehende Private Nachrichten nicht betroffen sind (0 = deaktiviert)";
$l['setting_wolcutoffmins'] = "Zeit bis zum Offline-Status";
$l['setting_wolcutoffmins_desc'] = "Die Anzahl der Minuten, nach denen ein Benutzer als offline angezeigt wird. Empfohlen: 15.";
$l['setting_enablecalendar'] = "Kalender aktivieren";
$l['setting_enablecalendar_desc'] = "Wähle \"Nein\", wenn du den Kalender komplett deaktivieren willst.";
$l['setting_refreshwol'] = "Aktualisierung der \"Wer ist online\"-Seite";
$l['setting_refreshwol_desc'] = "Die Anzahl der Minuten, nach denen sich die Seite automatisch neu lädt. Wähle 0, um diese Funktion zu deaktivieren.";
$l['setting_wolorder'] = "\"Wer ist online\" Sortierung";
$l['setting_wolorder_desc'] = "Sortiert die aktiven Benutzer nach Benutzername oder letzter Aktivität. Hinweis: Diese Einstellung gilt nur auf dem Protal und der Startseite.";
$l['setting_wolusersperpage'] = "Benutzer pro Seite";
$l['setting_wolusersperpage_desc'] = "Die Anzahl an Benutzern, die pro Seite angezeigt werden. (0 = Keine Begrenzung)";
$l['setting_woldisplayspiders'] = "\"Wer ist online\" zeigt Bots";
$l['setting_woldisplayspiders_desc'] = "Bots in der Liste anzeigen. Hinweis: Diese Einstellung gilt nur auf dem Protal und der Startseite.";
$l['setting_wolorder_username'] = "Sortiere nach Benutzername (aufsteigend)";
$l['setting_wolorder_activity'] = "Sortiere nach letzter Aktivität (absteigend)";
$l['setting_enablepruning'] = "Benutzerbereinigung aktivieren?";
$l['setting_enablepruning_desc'] = "Hier kann die Bereinigung von Benutzern nach den angegebenen Kriterien aktiviert werden.";
$l['setting_enableprunebyposts'] = "Bereinigung nach Beitragszahl?";
$l['setting_enableprunebyposts_desc'] = "Hier kann die Bereinigung nach Beitragszahl aktiviert werden.";
$l['setting_prunepostcount'] = "Beitragszahl";
$l['setting_prunepostcount_desc'] = "Benutzer mit weniger als der angegebenen Anzahl an Beiträgen werden gelöscht.";
$l['setting_prunepostcountall'] = "Alle Beiträge zählen?";
$l['setting_prunepostcountall_desc'] = "Wenn aktiviert, werden auch die Beiträge aus Foren, die von der Beitragszählung ausgenommen wurden, beim Bereinigen gezählt.";
$l['setting_dayspruneregistered'] = "Alter der Registrierung";
$l['setting_dayspruneregistered_desc'] = "Gib die Anzahl der Tage nach der Registrierung an, nach denen ein Benutzer mit weniger als der angegebenen Anzahl an Beiträgen gelöscht wird.";
$l['setting_pruneunactived'] = "Nicht aktivierte Benutzer löschen?";
$l['setting_pruneunactived_desc'] = "Hier kann die Bereinigung von nicht aktivierten Benutzeraccounts aktiviert werden.";
$l['setting_dayspruneunactivated'] = "Alter der Registrierung";
$l['setting_dayspruneunactivated_desc'] = "Wie viele Tage nach der Registrierung sollen nicht aktivierte Benutzeraccounts entfernt werden?";
$l['setting_prunethreads'] = "Beiträge und Themen beim Löschen von Benutzern mitlöschen";
$l['setting_prunethreads_desc'] = "Beim Löschen von Benutzern auch alle deren Themen und Beiträge löschen?";
$l['setting_portal'] = "Portal aktivieren";
$l['setting_portal_desc'] = "Wähle Nein aus, um das Portal zu deaktivieren";
$l['setting_portal_announcementsfid'] = "Foren für Ankündigungen";
$l['setting_portal_announcementsfid_desc'] = "Wähle die Foren aus, deren Nachrichten auf der Portal-Seite angezeigt werden sollen.";
$l['setting_portal_numannouncements'] = "Anzahl der angezeigten Ankündigungen";
$l['setting_portal_numannouncements_desc'] = "Wähle die Anzahl der Ankündigungen, die pro Seite im Portal angezeigt werden sollen.";
$l['setting_portal_showwelcome'] = "Zeige Willkommensbox";
$l['setting_portal_showwelcome_desc'] = "Soll Gästen/Benutzern eine Willkommensbox angezeigt werden?";
$l['setting_portal_showpms'] = "Zeige den Benutzern die PN-Anzahl";
$l['setting_portal_showpms_desc'] = "Soll den Benutzern angezeigt werden, wie viele Nachrichten in ihrem PN-System gespeichert sind?";
$l['setting_portal_showstats'] = "Zeige Foren-Statistiken";
$l['setting_portal_showstats_desc'] = "Soll die Anzahl der Themen, der Beiträge, der Mitglieder und das neueste Mitglied auf der Portal-Seite angezeigt werden?";
$l['setting_portal_showwol'] = "Zeige \"Wer ist online?\"";
$l['setting_portal_showwol_desc'] = "Soll auf der Portal-Seite angezeigt werden, wer online ist?";
$l['setting_portal_showsearch'] = "Zeige Such-Box";
$l['setting_portal_showsearch_desc'] = "Soll auf der Portal-Seite eine Such-Box angezeigt werden, mit der die Besucher dein Forum durchsuchen können?";
$l['setting_portal_showdiscussions'] = "Zuletzt beantwortete Themen";
$l['setting_portal_showdiscussions_desc'] = "Sollen die zuletzt beantworteten Themen auf der Portal-Seite angezeigt werden?";
$l['setting_portal_showdiscussionsnum'] = "Anzahl der zuletzt beantworteten Themen";
$l['setting_portal_showdiscussionsnum_desc'] = "Gib die Anzahl der zuletzt beantworteten Themen an, die auf der Portal-Seite angezeigt werden sollen.";
$l['setting_portal_excludediscussion'] = "Foren, deren zuletzt beantwortete Themen ausgeschlossen werden";
$l['setting_portal_excludediscussion_desc'] = "Wähle die Foren aus, deren zuletzt beantwortete Themen nicht angezeigt werden sollen.";
$l['setting_searchtype'] = "Suchtyp";
$l['setting_searchtype_desc'] = "Wähle das Suchsystem, das du verwenden möchtest. Du kannst wählen zwischen \"Standard\" oder \"Volltext\" (je nach Datenbank). Die Volltextsuche ist präziser und schneller als die Standardsuchfunktion des MyBB.";
$l['setting_searchtype_standard'] = "Standard";
$l['setting_searchtype_fulltext'] = "Volltext";
$l['setting_searchfloodtime'] = "Zeit zwischen Suchaktionen (Sekunden)";
$l['setting_searchfloodtime_desc'] = "Gib die Zeit in Sekunden an, die nach einer Suche vergehen muss, bevor eine neue Suche durchgeführt werden kann. Dies schützt vor der Überlastung des Servers durch Benutzer, die kontinuierlich Suchaktionen durchführen. Wähle 0, um diese Beschränkung zu deaktivieren.";
$l['setting_minsearchword'] = "Minimale Suchbegriffslänge";
$l['setting_minsearchword_desc'] = "Gib die minimal benötigte Zeichenzahl an, aus denen ein Suchbegriff bestehen muss. Wähle 0 zum Deaktivieren (Du akzeptierst dadurch die Minimallänge von 3 Zeichen für die normale Suche und 4 für die MySQL-Volltextsuche). Hast Du die Volltextsuche aktiviert und wählst eine geringere Anzahl, wird die Einstellung von MySQL überschrieben.";
$l['setting_searchhardlimit'] = "Maximale Anzahl an Suchergebnissen";
$l['setting_searchhardlimit_desc'] = "Hier kann die Anzahl an Suchergebnissen beschränkt werden (0 = Keine Beschränkung). Bei großen Foren (mit über 1 Millionen Beiträgen) sollte die Anzahl auf höchstens 1000 begrenzt werden.";
$l['setting_bbcodeinserter'] = "Editor aktivieren";
$l['setting_bbcodeinserter_desc'] = "Soll der Editor im Forum zur Verfügung stehen?";
$l['setting_partialmode'] = "Editor im Teilmodus";
$l['setting_partialmode_desc'] = "Wähle Ja aus, damit der Editor im Teilmodus angezeigt wird. Verschiedene MyCodes, wie [quote] und [img], werden dann als Text angezeigt.";
$l['setting_smilieinserter'] = "Liste mit Smilies zeigen";
$l['setting_smilieinserter_desc'] = "Soll die Liste mit Smilies neben dem Editor angezeigt werden?";
$l['setting_smilieinsertertot'] = "Anzahl der Smilies";
$l['setting_smilieinsertertot_desc'] = "Gib an, wie viele Smilies in der Liste angezeigt werden sollen.";
$l['setting_smilieinsertercols'] = "Anzahl der Spalten";
$l['setting_smilieinsertercols_desc'] = "Gib an, in wie vielen Spalten die Smilies in der Tabelle angezeigt werden sollen.";
$l['setting_allowbasicmycode'] = "Erlaube allgemeinen MyCodes";
$l['setting_allowbasicmycode_desc'] = "Wähle \"Ja\" um allgemeinen MyCode, wie Fett, Kursiv, Unterstrichen, Durchgestrichen und HR zu erlauben.";
$l['setting_allowcolormycode'] = "Erlaube Farb-MyCode (color)";
$l['setting_allowcolormycode_desc'] = "Wähle \"Ja\" um den Farb-MyCode zu erlauben.";
$l['setting_allowsizemycode'] = "Erlaube Größen-MyCode (size)";
$l['setting_allowsizemycode_desc'] = "Wähle \"Ja\" um den Größen-MyCode zu erlauben.";
$l['setting_allowfontmycode'] = "Erlaube Schrift-MyCode (font)";
$l['setting_allowfontmycode_desc'] = "Wähle \"Ja\" um den Schrift-MyCode zu erlauben.";
$l['setting_allowlinkmycode'] = "Erlaube Link-MyCode (link)";
$l['setting_allowlinkmycode_desc'] = "Wähle \"Ja\" um den Link-MyCode zu erlauben.";
$l['setting_allowautourl'] = "URLs automatisch in Links umwandeln";
$l['setting_allowautourl_desc'] = "Wähle \"Ja\" um Links automatisch umzuwandeln.";
$l['setting_allowemailmycode'] = "Erlaube E-Mail-MyCode (email)";
$l['setting_allowemailmycode_desc'] = "Wähle \"Ja\" um den E-Mail-MyCode zu erlauben.";
$l['setting_allowalignmycode'] = "Erlaube Ausrichtungs-MyCode (align)";
$l['setting_allowalignmycode_desc'] = "Wähle \"Ja\" um den Ausrichtungs-MyCode zu erlauben.";
$l['setting_allowlistmycode'] = "Erlaube Listen-MyCode (list)";
$l['setting_allowlistmycode_desc'] = "Wähle \"Ja\" um den Listen-MyCode zu erlauben.";
$l['setting_allowcodemycode'] = "Erlaube Code-MyCodes";
$l['setting_allowcodemycode_desc'] = "Wähle \"Ja\" um den PHP- und Code-MyCode zu erlauben.";
$l['setting_allowsymbolmycode'] = "Erlaube Symbol-MyCodes";
$l['setting_allowsymbolmycode_desc'] = "Wähle \"Ja\" um die MyCodes für (tm), (c) und (r) zu erlauben.";
$l['setting_allowmemycode'] = "Erlaube My-MyCodes";
$l['setting_allowmemycode_desc'] = "Wähle \"Ja\" um die Nutzung von /me und /slaps zu erlauben.";
$l['setting_guestimages'] = "Zeige Gästen Bilder in Beiträgen";
$l['setting_guestimages_desc'] = "Wähle \"Ja\", um Gästen zu erlauben Bilder in Beiträgen zu sehen.";
$l['setting_guestvideos'] = "Zeige Gästen Videos in Beiträgen";
$l['setting_guestvideos_desc'] = "Wähle \"Ja\", um Gästen zu erlauben Videos in Beiträgen zu sehen.";
$l['setting_cplanguage'] = "Control Panel-Sprache";
$l['setting_cplanguage_desc'] = "Wähle die Sprache des Admin-CPs.";
$l['setting_cpstyle'] = "Control Panel-Style";
$l['setting_cpstyle_desc'] = "Wähle den Standard-Style für das Admin-CP. Styles befinden sich im \"styles\"-Ordner auf dem Webspace. Der Name des Ordners wird zum Namen des Styles und die Datei \"style.css\" innerhalb des Ordners wird automatisch eingebunden.";
$l['setting_maxloginattempts'] = "Maximale Anzahl an Anmeldeversuchen";
$l['setting_maxloginattempts_desc'] = "Die maximale Anzahl an Anmeldeversuchen, bevor der Benutzer gesperrt wird (0 = deaktiviert).";
$l['setting_loginattemptstimeout'] = "Zeitspanne für Loginversuche";
$l['setting_loginattemptstimeout_desc'] = "Wie lange soll ein Benutzer nach der maximalen Anzahl an fehlgeschlagenen Anmeldeversuchen warten, bevor er sich erneut anmelden kann (in Minuten)? Wähle 0 um diese Funktion zu deaktivieren.";
$l['setting_mail_handler'] = "Mail-Handler";
$l['setting_mail_handler_desc'] = "Wähle das Medium, über das E-Mails des Forums verschickt werden sollen.";
$l['setting_mail_handler_mail'] = "PHP-Mail";
$l['setting_mail_handler_smtp'] = "SMTP-Mail";
$l['setting_smtp_host'] = "SMTP Hostname";
$l['setting_smtp_host_desc'] = "Gib den Hostnamen des SMTP-Servers an. Wird nur benötigt, wenn E-Mails per SMTP verschickt werden sollen.";
$l['setting_smtp_port'] = "SMTP Port";
$l['setting_smtp_port_desc'] = "Gib die Nummer des Ports an. Wird nur benötigt, wenn E-Mails per SMTP verschickt werden sollen.";
$l['setting_smtp_user'] = "SMTP Benutzer";
$l['setting_smtp_user_desc'] = "Gib den Benutzer für den Zugriff auf den SMTP-Server an. Wird nur benötigt, wenn E-Mails per SMTP verschickt werden sollen und der Server eine Autorisierung benötigt.";
$l['setting_smtp_pass'] = "SMTP Passwort";
$l['setting_smtp_pass_desc'] = "Gib das Passwort für den Zugriff auf den SMTP-Server an. Wird nur benötigt, wenn E-Mails per SMTP verschickt werden sollen und der Server eine Autorisierung benötigt.";
$l['setting_secure_smtp'] = "Sicheres SMTP";
$l['setting_secure_smtp_desc'] = "Wähle die Art der Verschlüsselung für die Verbindung zum SMTP-Server. Wird nur benötigt, wenn E-Mails per SMTP verschickt werden sollen.";
$l['setting_secure_smtp_0'] = "Keine Verschlüsselung";
$l['setting_secure_smtp_1'] = "SSL-Verschlüsselung";
$l['setting_secure_smtp_2'] = "TLS-Verschlüsselung";
$l['setting_mail_parameters'] = "Zusätzliche Parameter für die PHP-Funktion 'mail()'";
$l['setting_mail_parameters_desc'] = "<strong>Nicht unterstützt.</strong> Zusätzliche Parameter können stattdessen in der <a href=\"https://docs.mybb.com/1.8/faq/mail/#additional-parameters-for-phps-mail\">Konfiguration</a> festgelegt werden.";
$l['setting_mail_logging'] = "E-Mail loggen";
$l['setting_mail_logging_desc'] = "Hier kannst du einstellen, wie E-Mails über die \"Thema einem Freund senden\"-Funktion geloggt werden sollen. In einigen Ländern ist es nicht erlaubt, den Inhalt zu loggen.";
$l['setting_mail_logging_0'] = "E-Mails nicht loggen";
$l['setting_mail_logging_1'] = "E-Mails ohne Inhalt loggen";
$l['setting_mail_logging_2'] = "Alles loggen";
$l['setting_mail_message_id'] = "Nachrichten-ID in E-Mail-Kopf einfügen";
$l['setting_mail_message_id_desc'] = "Das Ausschalten dieser Option beseitigt bei manchen Hostern, dass E-Mails als Spam erkannt werden.";
$l['setting_contact'] = "Kontakt-Formular aktivieren";
$l['setting_contact_desc'] = "Aktiviere diese Option um den Zugriff auf das Kontakt-Formular zu erlauben.";
$l['setting_contact_guests'] = "Deaktiviere Kontakt-Formular für Gäste";
$l['setting_contact_guests_desc'] = "Wähle \"Ja\" um Gästen den Zugriff auf das Kontakt-Formular zu verbieten.";
$l['setting_contact_badwords'] = "Aktiviere Wortfilter in Kontakt-Formular";
$l['setting_contact_badwords_desc'] = "Wenn aktiviert, werden die Wortfilter vor dem Absenden auf Betreff und Nachricht angewendet.";
$l['setting_contact_maxsubjectlength'] = "Maximale Länge des Betreffs im Kontakt-Formular";
$l['setting_contact_maxsubjectlength_desc'] = "Die maximale Anzahl an Zeichen (in Bytes), die im Betreff erlaubt sind (0 = keine Begrenzung).";
$l['setting_contact_minmessagelength'] = "Minimale Länge der Nachricht im Kontakt-Formular";
$l['setting_contact_minmessagelength_desc'] = "Die minimale Anzahl an Zeichen, die zum Absenden einer Nachricht benötigt werden (0 = kein Minimum).";
$l['setting_contact_maxmessagelength'] = "Maximale Länge der Nachricht im Kontakt-Formular";
$l['setting_contact_maxmessagelength_desc'] = "Die maximale Anzahl an Zeichen, die beim Absenden einer Nachricht erlaubt sind (0 = keine Begrenzung).";
$l['setting_purgespammergroups'] = "Für welche Benutzergruppen verfügbar";
$l['setting_purgespammergroups_desc'] = "Wähle die Benutzergruppen, die Spammer löschen können.";
$l['setting_purgespammerpostlimit'] = "Beitrags-Limit";
$l['setting_purgespammerpostlimit_desc'] = "Diese Einstellung erlaubt dir einzustellen, ab welcher Beitragsanzahl ein Benutzer nicht gelöscht werden kann. Damit soll verhindert werden, dass aktive Benutzer gelöscht werden. Wähle 0 um die Beitragsanzahl nicht zu prüfen; dies wird allerdings nicht empfohlen.";
$l['setting_purgespammerbandelete'] = "Spammer sperren oder löschen";
$l['setting_purgespammerbandelete_desc'] = "Soll diese Funktion standardmäßig Benutzer sperren oder löschen.";
$l['setting_purgespammerbandelete_ban'] = "Dauerhaft sperren";
$l['setting_purgespammerbandelete_delete'] = "Löschen";
$l['setting_purgespammerbangroup'] = "Sperrgruppe";
$l['setting_purgespammerbangroup_desc'] = "Wähle die Gruppe aus, in die gesperrte Benutzer verschoben werden. Standard ist vorkonfigurierte Gruppe des MyBBs.";
$l['setting_purgespammerbanreason'] = "Sperrgrund";
$l['setting_purgespammerbanreason_desc'] = "Der Sperrgrund wird beim Sperren von Spammern verwendet.";
$l['setting_purgespammerapikey'] = "Stop Forum Spam API Key";
$l['setting_purgespammerapikey_desc'] = "Um die Daten von Spammern an Stop Forum Spam übermitteln zu können, benötigst du einen API-Key. Um einen zu erhalten, melde dich <a href=\"https://www.stopforumspam.com/forum/register.php\" target=\"_blank\" rel=\"noopener\">hier</a> an. Nach Erhalt des Keys, trage diesen hier ein.";
$l['setting_enablestopforumspam_on_register'] = "Prüfe Registrierungen mit StopForumSpam?";
$l['setting_enablestopforumspam_on_register_desc'] = "Sollen alle neue Registrierungen mit der Datenbank bei StopForumSpam.com abgeglichen werden?";
$l['setting_stopforumspam_on_contact'] = "Prüfe Anfrage von Gästen über das Kontakt-Formular mit StopForumSpam?";
$l['setting_stopforumspam_on_contact_desc'] = "Sollen E-Mail- und IP-Adresse von Gästen mit StopForumSpam.com abgeglichen werden, wenn sie das Kontakt-Formular benutzen?";
$l['setting_stopforumspam_on_newreply'] = "Prüfe Beiträge von Gästen mit StopForumSpam?";
$l['setting_stopforumspam_on_newreply_desc'] = "Sollen der Benutzername und die IP-Adresse von Gästen mit StopForumSpam.com abgeglichen werden, wenn sie neue Beiträge schreiben?";
$l['setting_stopforumspam_on_newthread'] = "Prüfe Themen von Gästen mit StopForumSpam?";
$l['setting_stopforumspam_on_newthread_desc'] = "Sollen der Benutzername und die IP-Adresse von Gästen mit StopForumSpam.com abgeglichen werden, wenn sie neue Themen schreiben?";
$l['setting_stopforumspam_min_weighting_before_spam'] = "Minimaler Schwellenwert für StopForumSpam";
$l['setting_stopforumspam_min_weighting_before_spam_desc'] = "Der minimale Wert von StopForumSpam, ab dem ein Benutzer für einen Spammer gehalten wird. Dies sollte eine Wert zwischen 0 und 100 sein.";
$l['setting_stopforumspam_check_usernames'] = "Prüfe Benutzernamen?";
$l['setting_stopforumspam_check_usernames_desc'] = "Soll der Benutzername mit der StopForumSpam-Datenbank abgeglichen werden?";
$l['setting_stopforumspam_check_emails'] = "Prüfe E-Mail-Adresse?";
$l['setting_stopforumspam_check_emails_desc'] = "Soll die E-Mail-Adresse mit der StopForumSpam-Datenbank abgeglichen werden?";
$l['setting_stopforumspam_check_ips'] = "Prüfe IP-Adresse?";
$l['setting_stopforumspam_check_ips_desc'] = "Soll die IP-Adresse mit der StopForumSpam-Datenbank abgeglichen werden?";
$l['setting_stopforumspam_block_on_error'] = "Bei StopForumSpam-Fehler blockieren?";
$l['setting_stopforumspam_block_on_error_desc'] = "Soll ein Benutzer blockiert werden, wenn ein Fehler beim Aufruf der StopForumSpam-API auftritt?";
$l['setting_stopforumspam_log_blocks'] = "StopForumSpam-Sperren aufzeichnen?";
$l['setting_stopforumspam_log_blocks_desc'] = "Sollen alle von StopForumSpam ausgelösten Sperrungen aufgezeichnet werden?";
$l['setting_allowskypefield'] = "Erlaube Skype-ID für Gruppen";
$l['setting_allowskypefield_desc'] = "Wähle die Gruppen aus, die ihren Skype-ID festlegen dürfen.";
$l['setting_allowgooglefield'] = "Erlaube Google-Hangouts-ID für Gruppen";
$l['setting_allowgooglefield_desc'] = "Wähle die Gruppen aus, die ihre Google-Hangouts-ID festlegen dürfen.";
$l['setting_statsenabled'] = "Forenstatistik aktivieren";
$l['setting_statsenabled_desc'] = "Um die Forenstatistik zu deaktivieren, wähle Nein aus.";
$l['setting_statscachetime'] = "Statistik Cache Aktualisierung";
$l['setting_statscachetime_desc'] = "Wähle die Zeitspanne (in Stunden), nach der der Statistik-Cache aktualisiert wird.";
$l['setting_enableshowteam'] = "Foren-Team-Seite aktivieren";
$l['setting_enableshowteam_desc'] = "Falls du die Foren-Team-Seite deaktivieren willst, wähle Nein aus.";
$l['setting_showaddlgroups'] = "Zeige sekundäre Gruppen";
$l['setting_showaddlgroups_desc'] = "Wähle, ob die Teamliste auch unter Berücksichtigung weiterer Gruppen gefüllt wird.";
$l['setting_showgroupleaders'] = "Zeige Gruppenleiter";
$l['setting_showgroupleaders_desc'] = "Sollen Gruppenleiter auf der Teamliste angezeigt werden?";
